CREATE OR REPLACE FORCE VIEW w83b.w83bdatosministerioactas (n_acta_016,
                                                            ccif_001,
                                                            rsoc_001,
                                                            cnae_001,
                                                            munic_001,
                                                            c_conv_016,
                                                            cmadrid_013,
                                                            totelec_016,
                                                            c_territ_016,
                                                            n_regdef_016,
                                                            f_elecc_016,
                                                            cempr_013,
                                                            ano_acta_016,
                                                            fregdef_016,
                                                            f_baja_016,
                                                            version_016,
                                                            domic_001,
                                                            c_sindi_024
                                                           )
AS
   SELECT consulta.nacta, consulta.ccif, consulta.rsoc, consulta.cnae,
          consulta.munic, consulta.c_conv, consulta.cmadrid, consulta.totelec,
          consulta.c_territ, consulta.n_regdef, consulta.f_elecc,
          consulta.cempr, consulta.ano_acta, consulta.fregdef,
          consulta.f_baja, consulta.ver, consulta.domic, consulta.sindi
     FROM (SELECT   n_acta_016 AS nacta, ccif_001 AS ccif, rsoc_001 AS rsoc,
                    cnae_001 AS cnae, munic_001 AS munic,
                    c_conv_016 AS c_conv, cmadrid_013 AS cmadrid,
                    totelec_016 AS totelec, c_territ_016 AS c_territ,
                    n_regdef_016 AS n_regdef, f_elecc_016 AS f_elecc,
                    cempr_013 AS cempr, ano_acta_016 AS ano_acta,
                    fregdef_016 AS fregdef, f_baja_016 AS f_baja,
                    version_016 AS ver, domic_001 AS domic,
                    stragg (c_sindi_024) AS sindi
               FROM w83b16s00, j7301s01, w83b13s00, w83b24s00
              WHERE n_regdef_016 IS NOT NULL
                AND n_acttot_016 IS NULL
                AND id_centro_016 = ccen_001
                AND c_conv_013 = c_conv_016
                AND version_016 = version_024
                AND n_acta_016 = n_acta_024
                AND c_territ_016 = c_territ_024
                AND ano_acta_016 = ano_acta_024
                AND validada_016 = 1
           GROUP BY n_acta_016,
                    ccif_001,
                    rsoc_001,
                    cnae_001,
                    munic_001,
                    c_conv_016,
                    cmadrid_013,
                    totelec_016,
                    c_territ_016,
                    n_regdef_016,
                    f_elecc_016,
                    cempr_013,
                    ano_acta_016,
                    fregdef_016,
                    f_baja_016,
                    version_016,
                    domic_001) consulta;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bdatosministeriocolegios (version_016,
                                                               n_acta_016,
                                                               c_territ_016,
                                                               ano_acta_016,
                                                               c_coleg_044,
                                                               elec_044,
                                                               vota_044,
                                                               pap_val_044,
                                                               pap_nul_044,
                                                               pap_bla_044,
                                                               n_delh_024,
                                                               n_delm_024,
                                                               n_votos_024,
                                                               fregdef_016,
                                                               f_elecc_016,
                                                               f_baja_016
                                                              )
AS
   SELECT   consulta.version_016, consulta.n_acta_016, consulta.c_territ_016,
            consulta.ano_acta_016, consulta.c_coleg_044, consulta.elec_044,
            consulta.vota_044, consulta.pap_val_044, consulta.pap_nul_044,
            consulta.pap_bla_044, consulta.n_delh_024, consulta.n_delm_024,
            consulta.n_votos_024, consulta.fregdef_016, consulta.f_elecc_016,
            consulta.f_baja_016
       FROM (SELECT version_016, n_acta_016, c_territ_016, ano_acta_016,
                    c_coleg_044, elec_044, vota_044, pap_val_044, pap_nul_044,
                    pap_bla_044, NVL (n_delh_024, 0) AS n_delh_024,
                    NVL (n_delm_024, 0) AS n_delm_024,
                    NVL (n_votos_024, 0) AS n_votos_024, fregdef_016,
                    f_elecc_016, f_baja_016
               FROM w83b16s00 w83b_16s00 LEFT OUTER JOIN w83b44s00 w83b_44s00
                    ON (    n_acta_016 = n_acta_044
                        AND ano_acta_016 = ano_acta_044
                        AND c_territ_016 = c_territ_044
                        AND version_016 = version_044
                       )
                    LEFT OUTER JOIN w83b24s00 w83b_24s00
                    ON (    n_acta_016 = n_acta_024
                        AND ano_acta_016 = ano_acta_024
                        AND c_territ_016 = c_territ_024
                        AND version_016 = version_024
                        AND c_coleg_024 = c_coleg_044
                       )
              WHERE validada_016 = 1
                AND n_regdef_016 IS NOT NULL
                AND n_acttot_016 IS NULL) consulta
   ORDER BY ano_acta_016, n_acta_016, c_territ_016, c_coleg_044;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bdatosministeriosind (version_016,
                                                           n_acta_016,
                                                           c_territ_016,
                                                           ano_acta_016,
                                                           c_coleg_024,
                                                           n_votos_024,
                                                           n_delh_024,
                                                           n_delm_024,
                                                           c_sindi_024,
                                                           fregdef_016,
                                                           f_elecc_016,
                                                           f_baja_016,
                                                           cmadrid_019
                                                          )
AS
   SELECT   consulta.version_016, consulta.n_acta_016 AS n_acta_016,
            consulta.c_territ_016 AS c_territ_016,
            consulta.ano_acta_016 AS ano_acta_016,
            consulta.c_coleg_024 AS c_coleg_024,
            consulta.n_votos_024 AS n_votos_024,
            consulta.n_delh_024 AS n_delh_024,
            consulta.n_delm_024 AS n_delm_024,
            consulta.c_sindi_024 AS c_sindi_024,
            consulta.fregdef_016 AS fregdef_016,
            consulta.f_elecc_016 AS f_elecc_016,
            consulta.f_baja_016 AS f_baja_016,
            consulta.cmadrid_019 AS cmadrid_019
       FROM (SELECT version_016, n_acta_016, c_territ_016, ano_acta_016,
                    c_coleg_024, NVL (n_votos_024, 0) AS n_votos_024,
                    NVL ((n_delh_024), '0') AS n_delh_024,
                    NVL ((n_delm_024), '0') AS n_delm_024, c_sindi_024,
                    fregdef_016, f_elecc_016, f_baja_016, cmadrid_019
               FROM w83b16s00, w83b24s00, w83b19s00
              WHERE n_acta_016 = n_acta_024
                AND ano_acta_016 = ano_acta_024
                AND c_territ_016 = c_territ_024
                AND version_016 = version_024
                AND c_sindi_024 = c_sindi_019(+)
                AND validada_016 = 1
                AND n_regdef_016 IS NOT NULL
                AND n_acttot_016 IS NULL) consulta
   ORDER BY ano_acta_016, n_acta_016, c_territ_016, c_coleg_024;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bdatosministerioanual (n_acta_016,
                                                            ano_acta_016,
                                                            version_016,
                                                            c_sindi_024,
                                                            desc_019,
                                                            siglas_019,
                                                            c_territ_016,
                                                            n_del,
                                                            n_delm_024,
                                                            c_conv_016,
                                                            cmadrid_019,
                                                            fregdef_016,
                                                            f_elecc_016,
                                                            f_baja_016
                                                           )
AS
   SELECT consulta.n_acta_016, consulta.ano_acta_016, consulta.version_016,
          consulta.c_sindi_024, consulta.desc_019, consulta.siglas_019,
          consulta.c_territ_016, consulta.n_del, consulta.n_delm_024,
          consulta.c_conv_016, consulta.cmadrid_019, consulta.fregdef_016,
          consulta.f_elecc_016, consulta.f_baja_016
     FROM (SELECT   n_acta_016, ano_acta_016, version_016, c_sindi_024,
                    desc_019, siglas_019, c_territ_016,
                    SUM (n_delh_024 + n_delm_024) AS n_del,
                    SUM (n_delm_024) AS n_delm_024,
                    (CASE
                        WHEN (    SUBSTR (c_conv_016, 1, 1) = 9
                              AND LENGTH (c_conv_016) = 3
                             )
                           THEN '1'
                        ELSE '0'
                     END
                    ) AS c_conv_016,
                    cmadrid_019, fregdef_016, f_elecc_016, f_baja_016
               FROM w83b16s00, w83b24s00, w83b19s00
              WHERE n_acta_016 = n_acta_024
                AND ano_acta_016 = ano_acta_024
                AND c_territ_016 = c_territ_024
                AND version_016 = version_024
                AND c_sindi_024 = c_sindi_019(+)
                AND n_regdef_016 IS NOT NULL
                AND n_acttot_016 IS NULL
                AND validada_016 = 1
           GROUP BY c_sindi_024,
                    desc_019,
                    siglas_019,
                    c_territ_016,
                    n_acta_016,
                    ano_acta_016,
                    version_016,
                    (CASE
                        WHEN (    SUBSTR (c_conv_016, 1, 1) = 9
                              AND LENGTH (c_conv_016) = 3
                             )
                           THEN '1'
                        ELSE '0'
                     END
                    ),
                    cmadrid_019,
                    fregdef_016,
                    f_elecc_016,
                    f_baja_016) consulta;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bcertdelegadossector (codsector,
                                                           codsindi,
                                                           descsindcast,
                                                           descsindeusk,
                                                           felec,
                                                           nacta,
                                                           anoacta,
                                                           territ,
                                                           vers,
                                                           fregdef,
                                                           fechabaja,
                                                           numdelegados
                                                          )
AS
   SELECT codsector, codsindi, descsindcast, descsindeusk, felec, nacta,
          anoacta, territ, vers, fregdef, fechabaja, numdelegados
     FROM (SELECT   centro.codsector AS codsector,
                    escrutinios.c_sindi_024 AS codsindi,
                    sindicato.desc_019 AS descsindcast,
                    sindicato.dese_019 AS descsindeusk,
                    actas.f_elecc_016 AS felec, actas.n_acta_016 AS nacta,
                    actas.ano_acta_016 AS anoacta,
                    actas.c_territ_016 AS territ, actas.version_016 AS vers,
                    actas.fregdef_016 AS fregdef,
                    actas.f_baja_016 AS fechabaja,
                    NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024),
                         '0'
                        ) AS numdelegados
               FROM w83b16s00 actas,
                    w83bcentrotrabajocompleto centro,
                    w83b24s00 escrutinios,
                    w83b19s00 sindicato
              WHERE actas.id_centro_016 = centro.codcentro
                AND actas.n_acta_016 = escrutinios.n_acta_024
                AND actas.ano_acta_016 = escrutinios.ano_acta_024
                AND actas.c_territ_016 = escrutinios.c_territ_024
                AND actas.version_016 = escrutinios.version_024
                AND escrutinios.c_sindi_024 = sindicato.c_sindi_019(+)
                AND actas.n_acttot_016 IS NULL
                AND actas.validada_016 = 1
                AND actas.n_regdef_016 IS NOT NULL
           GROUP BY centro.codsector,
                    escrutinios.c_sindi_024,
                    sindicato.desc_019,
                    sindicato.dese_019,
                    actas.f_elecc_016,
                    actas.n_acta_016,
                    actas.ano_acta_016,
                    actas.c_territ_016,
                    actas.version_016,
                    actas.fregdef_016,
                    actas.f_baja_016
           UNION ALL
           SELECT   centro.codsector AS codsector,
                    diferencias.c_sindi_018 AS codsindi,
                    sindicato.desc_019 AS descsindcast,
                    sindicato.dese_019 AS descsindeusk,
                    actas.f_elecc_016 AS felec, actas.n_acta_016 AS nacta,
                    actas.ano_acta_016 AS anoacta,
                    actas.c_territ_016 AS territ, actas.version_016 AS vers,
                    actas.fregdef_016 AS fregdef,
                    actas.f_baja_016 AS fechabaja,
                    NVL (SUM (diferencias.n_delm_018 + diferencias.n_delh_018),
                         '0'
                        ) AS numdelegados
               FROM w83b16s00 actas,
                    w83bcentrotrabajocompleto centro,
                    w83b18s00 diferencias,
                    w83b19s00 sindicato
              WHERE actas.id_centro_016 = centro.codcentro
                AND actas.n_acta_016 = diferencias.n_acta_018
                AND actas.ano_acta_016 = diferencias.ano_acta_018
                AND actas.c_territ_016 = diferencias.c_territ_018
                AND actas.version_016 = diferencias.version_018
                AND diferencias.c_sindi_018 = sindicato.c_sindi_019(+)
                AND actas.n_acttot_016 IS NULL
                AND actas.validada_016 = 1
                AND actas.n_regdef_016 IS NOT NULL
           GROUP BY centro.codsector,
                    diferencias.c_sindi_018,
                    sindicato.desc_019,
                    sindicato.dese_019,
                    actas.f_elecc_016,
                    actas.n_acta_016,
                    actas.ano_acta_016,
                    actas.c_territ_016,
                    actas.version_016,
                    actas.fregdef_016,
                    actas.f_baja_016) consulta;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bcertempresa (siglas,
                                                   razon,
                                                   descsindcast,
                                                   descsindeusk,
                                                   codcentro,
                                                   fecha_eleccion,
                                                   codsindicato,
                                                   fecha_alta,
                                                   numeroregistro,
                                                   fecha_registro,
                                                   observaciones,
                                                   actatotal,
                                                   num_acta,
                                                   anyo_acta,
                                                   territorio_acta,
                                                   alava,
                                                   vizcaya,
                                                   guipuzcoa,
                                                   cif,
                                                   numero
                                                  )
AS
   SELECT   siglas, razon, desc_019 AS desccast, dese_019 AS desceusk,
            codigocentro, fecha_eleccion, c_sindi_019 AS codsind, fechaalta,
            numeroregistro, fecharegistro, observaciones, acta, num_acta,
            anyo_acta, territorio_acta,
            NVL (SUM (CASE
                         WHEN (territorio_acta = 01)
                            THEN numdelegados
                         ELSE 0
                      END),
                 0
                ) AS alava,
            NVL (SUM (CASE
                         WHEN (territorio_acta = 48)
                            THEN numdelegados
                         ELSE 0
                      END),
                 0
                ) AS vizcaya,
            NVL (SUM (CASE
                         WHEN (territorio_acta = 20)
                            THEN numdelegados
                         ELSE 0
                      END),
                 0
                ) AS guipuzcoa,
            ccif_001, ncen_001
       FROM (SELECT   acta.n_acta_016 AS num_acta,
                      acta.ano_acta_016 AS anyo_acta,
                      acta.c_territ_016 AS territorio_acta,
                      acta.version_016 AS versionacta,
                      escrutinios.c_sindi_024 AS sindicato,
                      sind.siglas_019 AS siglas,
                      NVL (SUM (escrutinios.n_delm_024
                                + escrutinios.n_delh_024
                               ),
                           '0'
                          ) AS numdelegados,
                      desc_019 AS desc_019, dese_019 AS dese_019, c_sindi_019,
                      rsoc_001 AS razon, f_elecc_016 AS fecha_eleccion,
                      f_entra_016 AS fechaalta,
                      (   c_territ_016
                       || '/'
                       || ano_regdef_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (n_regdef_016)),
                                  1, '00000' || TO_CHAR (n_regdef_016),
                                  2, '0000' || TO_CHAR (n_regdef_016),
                                  3, '000' || TO_CHAR (n_regdef_016),
                                  4, '00' || TO_CHAR (n_regdef_016),
                                  5, '0' || TO_CHAR (n_regdef_016),
                                  TO_CHAR (n_regdef_016)
                                 )
                      ) numeroregistro,
                      (   acta.c_territ_016
                       || '/'
                       || acta.ano_acta_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                  1, '00000' || TO_CHAR (acta.n_acta_016),
                                  2, '0000' || TO_CHAR (acta.n_acta_016),
                                  3, '000' || TO_CHAR (acta.n_acta_016),
                                  4, '00' || TO_CHAR (acta.n_acta_016),
                                  5, '0' || TO_CHAR (acta.n_acta_016),
                                  TO_CHAR (acta.n_acta_016)
                                 )
                      ) acta,
                      fregdef_016 AS fecharegistro,
                      observ_016 AS observaciones, ccen_001 AS codigocentro,
                      ccif_001, ncen_001
                 FROM w83b24s00 escrutinios,
                      w83b16s00 acta,
                      w83b19s00 sind,
                      j7301s01
                WHERE escrutinios.n_acta_024 = acta.n_acta_016
                  AND escrutinios.ano_acta_024 = acta.ano_acta_016
                  AND escrutinios.version_024 = acta.version_016
                  AND escrutinios.c_territ_024 = acta.c_territ_016
                  AND sind.c_sindi_019 = escrutinios.c_sindi_024
                  AND acta.id_centro_016 = ccen_001
                  AND acta.f_baja_016 IS NULL
                  AND acta.n_regdef_016 IS NOT NULL
                  AND acta.validada_016 = 1
                  AND acta.n_acttot_016 IS NULL
             GROUP BY acta.n_acta_016,
                      acta.ano_acta_016,
                      acta.c_territ_016,
                      acta.version_016,
                      escrutinios.c_sindi_024,
                      sind.siglas_019,
                      desc_019,
                      dese_019,
                      c_sindi_019,
                      rsoc_001,
                      f_elecc_016,
                      f_entra_016,
                      (   c_territ_016
                       || '/'
                       || ano_regdef_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (n_regdef_016)),
                                  1, '00000' || TO_CHAR (n_regdef_016),
                                  2, '0000' || TO_CHAR (n_regdef_016),
                                  3, '000' || TO_CHAR (n_regdef_016),
                                  4, '00' || TO_CHAR (n_regdef_016),
                                  5, '0' || TO_CHAR (n_regdef_016),
                                  TO_CHAR (n_regdef_016)
                                 )
                      ),
                      (   acta.c_territ_016
                       || '/'
                       || acta.ano_acta_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                  1, '00000' || TO_CHAR (acta.n_acta_016),
                                  2, '0000' || TO_CHAR (acta.n_acta_016),
                                  3, '000' || TO_CHAR (acta.n_acta_016),
                                  4, '00' || TO_CHAR (acta.n_acta_016),
                                  5, '0' || TO_CHAR (acta.n_acta_016),
                                  TO_CHAR (acta.n_acta_016)
                                 )
                      ),
                      fregdef_016,
                      observ_016,
                      ccen_001,
                      ccif_001,
                      ncen_001
             UNION ALL
             SELECT   acta.n_acta_016 AS num_acta,
                      acta.ano_acta_016 AS anyo_acta,
                      acta.c_territ_016 AS territorio_acta,
                      acta.version_016 AS versionacta,
                      diferencias.c_sindi_018 AS sindicato,
                      sind.siglas_019 AS siglas,
                      NVL (SUM (diferencias.n_delm_018
                                + diferencias.n_delh_018
                               ),
                           '0'
                          ) AS numdelegados,
                      desc_019 AS desc_019, dese_019 AS dese_019, c_sindi_019,
                      rsoc_001 AS razon, f_elecc_016 AS fecha_eleccion,
                      f_entra_016 AS fechaalta,
                      (   c_territ_016
                       || '/'
                       || ano_regdef_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (n_regdef_016)),
                                  1, '00000' || TO_CHAR (n_regdef_016),
                                  2, '0000' || TO_CHAR (n_regdef_016),
                                  3, '000' || TO_CHAR (n_regdef_016),
                                  4, '00' || TO_CHAR (n_regdef_016),
                                  5, '0' || TO_CHAR (n_regdef_016),
                                  TO_CHAR (n_regdef_016)
                                 )
                      ) numeroregistro,
                      (   acta.c_territ_016
                       || '/'
                       || acta.ano_acta_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                  1, '00000' || TO_CHAR (acta.n_acta_016),
                                  2, '0000' || TO_CHAR (acta.n_acta_016),
                                  3, '000' || TO_CHAR (acta.n_acta_016),
                                  4, '00' || TO_CHAR (acta.n_acta_016),
                                  5, '0' || TO_CHAR (acta.n_acta_016),
                                  TO_CHAR (acta.n_acta_016)
                                 )
                      ) acta,
                      fregdef_016 AS fecharegistro,
                      observ_016 AS observaciones, ccen_001 AS codigocentro,
                      ccif_001, ncen_001
                 FROM w83b18s00 diferencias,
                      w83b16s00 acta,
                      w83b19s00 sind,
                      j7301s01
                WHERE diferencias.n_acta_018 = acta.n_acta_016
                  AND diferencias.ano_acta_018 = acta.ano_acta_016
                  AND diferencias.version_018 = acta.version_016
                  AND diferencias.c_territ_018 = acta.c_territ_016
                  AND sind.c_sindi_019 = diferencias.c_sindi_018
                  AND acta.id_centro_016 = ccen_001
                  AND acta.f_baja_016 IS NULL
                  AND acta.n_regdef_016 IS NOT NULL
                  AND acta.validada_016 = 1
                  AND acta.n_acttot_016 IS NULL
             GROUP BY acta.n_acta_016,
                      acta.ano_acta_016,
                      acta.c_territ_016,
                      acta.version_016,
                      diferencias.c_sindi_018,
                      sind.siglas_019,
                      desc_019,
                      dese_019,
                      c_sindi_019,
                      rsoc_001,
                      f_elecc_016,
                      f_entra_016,
                      (   c_territ_016
                       || '/'
                       || ano_regdef_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (n_regdef_016)),
                                  1, '00000' || TO_CHAR (n_regdef_016),
                                  2, '0000' || TO_CHAR (n_regdef_016),
                                  3, '000' || TO_CHAR (n_regdef_016),
                                  4, '00' || TO_CHAR (n_regdef_016),
                                  5, '0' || TO_CHAR (n_regdef_016),
                                  TO_CHAR (n_regdef_016)
                                 )
                      ),
                      (   acta.c_territ_016
                       || '/'
                       || acta.ano_acta_016
                       || '/'
                       || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                  1, '00000' || TO_CHAR (acta.n_acta_016),
                                  2, '0000' || TO_CHAR (acta.n_acta_016),
                                  3, '000' || TO_CHAR (acta.n_acta_016),
                                  4, '00' || TO_CHAR (acta.n_acta_016),
                                  5, '0' || TO_CHAR (acta.n_acta_016),
                                  TO_CHAR (acta.n_acta_016)
                                 )
                      ),
                      fregdef_016,
                      observ_016,
                      ccen_001,
                      ccif_001,
                      ncen_001) consulta
      WHERE consulta.versionacta =
               (SELECT MAX (version_016)
                  FROM w83b16s00 act
                 WHERE consulta.num_acta = act.n_acta_016
                   AND consulta.anyo_acta = act.ano_acta_016
                   AND consulta.territorio_acta = act.c_territ_016
                   AND act.validada_016 = 1)
   GROUP BY acta,
            num_acta,
            anyo_acta,
            territorio_acta,
            siglas,
            desc_019,
            dese_019,
            razon,
            codigocentro,
            fecha_eleccion,
            c_sindi_019,
            fechaalta,
            numeroregistro,
            fecharegistro,
            observaciones,
            ccif_001,
            ncen_001;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bcertlistadelegados (nombre,
                                                          apellido1,
                                                          apellido2,
                                                          dni,
                                                          siglas,
                                                          fecha_alta,
                                                          territorio_acta,
                                                          anyo_acta,
                                                          num_acta
                                                         )
AS
   SELECT DISTINCT nombre, apellido1, apellido2, dni, siglas, fechaalta,
                   territorio_acta, ano_acta, num_acta
              FROM (SELECT acta.n_acta_016 AS num_acta,
                           acta.ano_acta_016 AS ano_acta,
                           acta.c_territ_016 AS territorio_acta,
                           acta.version_016 AS version_acta,
                           acta.validada_016 AS validada,
                           centros.ccif_001 AS cif, del.nombre_025 AS nombre,
                           del.apel1_025 AS apellido1,
                           del.apel2_025 AS apellido2, del.dni_025 AS dni,
                           sind.siglas_019 AS siglas, desc_019 AS desccentro,
                           del.f_alta_025 AS fechaalta
                      FROM w83b25t00 del,
                           w83b16s00 acta,
                           j7301s01 centros,
                           w83b19s00 sind
                     WHERE del.n_acta_025 = acta.n_acta_016
                       AND del.ano_acta_025 = acta.ano_acta_016
                       AND del.version_025 = acta.version_016
                       AND del.c_territ_025 = acta.c_territ_016
                       AND centros.ccen_001 = acta.id_centro_016
                       AND sind.c_sindi_019 = del.c_sindi_025
                       AND del.f_baja_025 IS NULL
                       AND acta.f_baja_016 IS NULL
                       AND acta.fregdef_016 IS NOT NULL
                       AND acta.n_regdef_016 IS NOT NULL) consulta
             WHERE consulta.version_acta =
                      (SELECT MAX (version_016)
                         FROM w83b16s00 act
                        WHERE consulta.num_acta = act.n_acta_016
                          AND consulta.ano_acta = act.ano_acta_016
                          AND consulta.territorio_acta = act.c_territ_016
                          AND act.validada_016 = 1)
               AND consulta.validada = 1;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bcertnegrepres (num_acta,
                                                     fecha_eleccion,
                                                     descsindcast,
                                                     descsindeusk,
                                                     codcentro,
                                                     codsindicato,
                                                     territorio_acta,
                                                     fecharegistro,
                                                     fechabaja,
                                                     fechaactu,
                                                     ano_acta,
                                                     ver,
                                                     nacta,
                                                     numdelegados
                                                    )
AS
   SELECT   (   actas.c_territ_016
             || '/'
             || actas.ano_acta_016
             || '/'
             || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                        1, '00000' || TO_CHAR (actas.n_acta_016),
                        2, '0000' || TO_CHAR (actas.n_acta_016),
                        3, '000' || TO_CHAR (actas.n_acta_016),
                        4, '00' || TO_CHAR (actas.n_acta_016),
                        5, '0' || TO_CHAR (actas.n_acta_016),
                        TO_CHAR (actas.n_acta_016)
                       )
            ) num_acta,
            actas.f_elecc_016 AS fecha_eleccion,
            sindicato.desc_019 AS descsindcast,
            sindicato.dese_019 AS descsindeusk, actas.id_centro_016 centro,
            sindicato.c_sindi_019 AS codsind, actas.c_territ_016 AS territ,
            actas.fregdef_016 AS fecharegistro, actas.f_baja_016 AS fechabaja,
            actas.factu_016 AS factu, actas.ano_acta_016 AS ano_acta,
            actas.version_016 AS ver, actas.n_acta_016 AS nacta,
            NVL (SUM (escrutinios.n_delm_024 + escrutinios.n_delh_024),
                 '0'
                ) AS numdelegados
       FROM w83b16s00 actas, w83b24s00 escrutinios, w83b19s00 sindicato
      WHERE actas.n_acta_016 = escrutinios.n_acta_024(+)
        AND actas.ano_acta_016 = escrutinios.ano_acta_024(+)
        AND actas.c_territ_016 = escrutinios.c_territ_024(+)
        AND actas.version_016 = escrutinios.version_024(+)
        AND escrutinios.c_sindi_024 = sindicato.c_sindi_019(+)
        AND actas.n_acttot_016 IS NULL
        AND actas.validada_016 = 1
        AND actas.n_regdef_016 IS NOT NULL
   GROUP BY (   actas.c_territ_016
             || '/'
             || actas.ano_acta_016
             || '/'
             || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                        1, '00000' || TO_CHAR (actas.n_acta_016),
                        2, '0000' || TO_CHAR (actas.n_acta_016),
                        3, '000' || TO_CHAR (actas.n_acta_016),
                        4, '00' || TO_CHAR (actas.n_acta_016),
                        5, '0' || TO_CHAR (actas.n_acta_016),
                        TO_CHAR (actas.n_acta_016)
                       )
            ),
            actas.f_elecc_016,
            sindicato.desc_019,
            sindicato.dese_019,
            actas.id_centro_016,
            sindicato.c_sindi_019,
            actas.c_territ_016,
            actas.fregdef_016,
            actas.f_baja_016,
            actas.factu_016,
            actas.ano_acta_016,
            actas.version_016,
            actas.n_acta_016
   UNION ALL
   SELECT   (   actas.c_territ_016
             || '/'
             || actas.ano_acta_016
             || '/'
             || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                        1, '00000' || TO_CHAR (actas.n_acta_016),
                        2, '0000' || TO_CHAR (actas.n_acta_016),
                        3, '000' || TO_CHAR (actas.n_acta_016),
                        4, '00' || TO_CHAR (actas.n_acta_016),
                        5, '0' || TO_CHAR (actas.n_acta_016),
                        TO_CHAR (actas.n_acta_016)
                       )
            ) num_acta,
            actas.f_elecc_016 AS fecha_eleccion,
            sindicato.desc_019 AS descsindcast,
            sindicato.dese_019 AS descsindeusk, actas.id_centro_016 centro,
            sindicato.c_sindi_019 AS codsind, actas.c_territ_016 AS territ,
            actas.fregdef_016 AS fecharegistro, actas.f_baja_016 AS fechabaja,
            actas.factu_016 AS factu, actas.ano_acta_016 AS ano_acta,
            actas.version_016 AS ver, actas.n_acta_016 AS nacta,
            NVL (SUM (diferencias.n_delm_018 + diferencias.n_delh_018),
                 '0'
                ) AS numdelegados
       FROM w83b16s00 actas, w83b18s00 diferencias, w83b19s00 sindicato
      WHERE actas.n_acta_016 = diferencias.n_acta_018(+)
        AND actas.ano_acta_016 = diferencias.ano_acta_018(+)
        AND actas.c_territ_016 = diferencias.c_territ_018(+)
        AND actas.version_016 = diferencias.version_018(+)
        AND diferencias.c_sindi_018 = sindicato.c_sindi_019(+)
        AND actas.n_acttot_016 IS NULL
        AND actas.validada_016 = 1
        AND actas.n_regdef_016 IS NOT NULL
   GROUP BY (   actas.c_territ_016
             || '/'
             || actas.ano_acta_016
             || '/'
             || DECODE (LENGTH (TO_CHAR (actas.n_acta_016)),
                        1, '00000' || TO_CHAR (actas.n_acta_016),
                        2, '0000' || TO_CHAR (actas.n_acta_016),
                        3, '000' || TO_CHAR (actas.n_acta_016),
                        4, '00' || TO_CHAR (actas.n_acta_016),
                        5, '0' || TO_CHAR (actas.n_acta_016),
                        TO_CHAR (actas.n_acta_016)
                       )
            ),
            actas.f_elecc_016,
            sindicato.desc_019,
            sindicato.dese_019,
            actas.id_centro_016,
            sindicato.c_sindi_019,
            actas.c_territ_016,
            actas.fregdef_016,
            actas.f_baja_016,
            actas.factu_016,
            actas.ano_acta_016,
            actas.version_016,
            actas.n_acta_016;
/
CREATE OR REPLACE FORCE VIEW w83b.w83bcertorganorepr (actatotal,
                                                      num_acta,
                                                      anyo_acta,
                                                      territorio_acta,
                                                      fecha_eleccion,
                                                      razon,
                                                      codprovincia,
                                                      codmunicipio,
                                                      cif,
                                                      numero
                                                     )
AS
   SELECT DISTINCT (acta), num_acta, anyo_acta, territorio_acta,
                   fecha_eleccion, empresa, codprovincia, codmunicipio, cif,
                   numero
              FROM (SELECT    acta.c_territ_016
                           || '/'
                           || acta.ano_acta_016
                           || '/'
                           || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                      1, '00000' || TO_CHAR (acta.n_acta_016),
                                      2, '0000' || TO_CHAR (acta.n_acta_016),
                                      3, '000' || TO_CHAR (acta.n_acta_016),
                                      4, '00' || TO_CHAR (acta.n_acta_016),
                                      5, '0' || TO_CHAR (acta.n_acta_016),
                                      TO_CHAR (acta.n_acta_016)
                                     ) acta,
                           acta.n_acta_016 AS num_acta,
                           acta.ano_acta_016 AS anyo_acta,
                           acta.c_territ_016 AS territorio_acta,
                           acta.version_016 AS version_acta,
                           acta.f_elecc_016 AS fecha_eleccion,
                           centros.rsoc_001 AS empresa,
                           centros.provc_001 AS codprovincia,
                           centros.munic_001 AS codmunicipio,
                           centros.ccif_001 AS cif,
                           centros.ncen_001 AS numero
                      FROM w83b24s00 escrutinios,
                           w83b16s00 acta,
                           j7301s01 centros,
                           w83b19s00 sind
                     WHERE escrutinios.n_acta_024 = acta.n_acta_016
                       AND escrutinios.ano_acta_024 = acta.ano_acta_016
                       AND escrutinios.version_024 = acta.version_016
                       AND escrutinios.c_territ_024 = acta.c_territ_016
                       AND centros.ccen_001 = acta.id_centro_016
                       AND sind.c_sindi_019 = escrutinios.c_sindi_024
                       AND acta.f_baja_016 IS NULL
                       AND acta.n_regdef_016 IS NOT NULL
                       AND acta.validada_016 = 1
                       AND acta.n_acttot_016 IS NULL
                    UNION ALL
                    SELECT    acta.c_territ_016
                           || '/'
                           || acta.ano_acta_016
                           || '/'
                           || DECODE (LENGTH (TO_CHAR (acta.n_acta_016)),
                                      1, '00000' || TO_CHAR (acta.n_acta_016),
                                      2, '0000' || TO_CHAR (acta.n_acta_016),
                                      3, '000' || TO_CHAR (acta.n_acta_016),
                                      4, '00' || TO_CHAR (acta.n_acta_016),
                                      5, '0' || TO_CHAR (acta.n_acta_016),
                                      TO_CHAR (acta.n_acta_016)
                                     ) acta,
                           acta.n_acta_016 AS num_acta,
                           acta.ano_acta_016 AS anyo_acta,
                           acta.c_territ_016 AS territorio_acta,
                           acta.version_016 AS version_acta,
                           acta.f_elecc_016 AS fecha_eleccion,
                           centros.rsoc_001 AS empresa,
                           centros.provc_001 AS codprovincia,
                           centros.munic_001 AS codmunicipio,
                           centros.ccif_001 AS cif,
                           centros.ncen_001 AS numero
                      FROM w83b18s00 diferencias,
                           w83b16s00 acta,
                           j7301s01 centros,
                           w83b19s00 sind
                     WHERE diferencias.n_acta_018 = acta.n_acta_016
                       AND diferencias.ano_acta_018 = acta.ano_acta_016
                       AND diferencias.version_018 = acta.version_016
                       AND diferencias.c_territ_018 = acta.c_territ_016
                       AND centros.ccen_001 = acta.id_centro_016
                       AND sind.c_sindi_019 = diferencias.c_sindi_018
                       AND acta.f_baja_016 IS NULL
                       AND acta.n_regdef_016 IS NOT NULL
                       AND acta.validada_016 = 1
                       AND acta.n_acttot_016 IS NULL) consulta
             WHERE consulta.version_acta =
                      (SELECT MAX (version_016)
                         FROM w83b16s00 act
                        WHERE consulta.num_acta = act.n_acta_016
                          AND consulta.anyo_acta = act.ano_acta_016
                          AND consulta.territorio_acta = act.c_territ_016
                          AND act.validada_016 = 1);
/